package ibase.webitm.ejb.vhb.msq1;

import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;
import ibase.utility.*;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class CostDetails extends ValidatorEJB {
	private String usersiteCode = "";
	private E12GenericUtility genericUtility = new E12GenericUtility();

	public CostDetails(UserInfoBean userInfoBean) {
		setUserInfo(userInfoBean);
		userInfoBean = getUserInfo();
		this.usersiteCode = userInfoBean.getSiteCode();
	}
	

	public Map<String, List<List<String>>> getItemDetails(String itemCode) throws Exception {
		Map<String, List<List<String>>> combinedMap = new HashMap<>();
		combinedMap.put("cost", getCostDetails(itemCode));
		combinedMap.put("price", getPriceListDetails(itemCode));
		return combinedMap;
	}

	private List<List<String>> getCostDetails(String itemCode) throws Exception
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", descr="" ,item = "" , rmCost = "" , pmCost = "" , otherCosts = "" , effFrom = "" , validUpto = "" , costPerUnit = "" ;
		List<List<String>> costList = new ArrayList<>();

		try 
		{
			conn = getConnection();
			sql = "SELECT cm.item_code, it.descr, cm.rm_cost, cm.pm_cost, cm.other_costs, cm.effective_from_date, cm.valid_upto_date, cm.cost_per_unit FROM costing_mst cm LEFT JOIN item it ON cm.item_code = it.item_code WHERE cm.item_code = ? ORDER BY effective_from_date DESC";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode.trim());
			rs = pstmt.executeQuery();
			while (rs.next()) 
			{
				item = checkNull(rs.getString("item_code"));
				descr = checkNull(rs.getString("descr"));
				rmCost = checkNull(rs.getString("rm_cost"));
				pmCost = checkNull(rs.getString("pm_cost"));
				otherCosts = checkNull(rs.getString("other_costs"));
				effFrom = checkNull(rs.getString("effective_from_date"));
				validUpto = checkNull(rs.getString("valid_upto_date"));
				costPerUnit = checkNull(rs.getString("cost_per_unit"));

				
				SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
				Date effFromDate = simpleDateFormat.parse(effFrom);
				Date validUptoDate = simpleDateFormat.parse(validUpto);

				SimpleDateFormat displayFormat = new SimpleDateFormat("dd/MM/yy");
				String formattedEffFrom = displayFormat.format(effFromDate);
				String formattedValidUpto = displayFormat.format(validUptoDate);

				List<String> row = new ArrayList<>();
				row.add(item);
				row.add(descr);
				row.add(rmCost);
				row.add(pmCost);
				row.add(otherCosts);
				row.add(formattedEffFrom);
				row.add(formattedValidUpto);
				row.add(costPerUnit);

				costList.add(row);
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("3", getUserInfo(), null, "Exception in getCostDetails: " + e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			
			if (rs != null) {
				rs.close();
			}
			if (pstmt != null) {
				pstmt.close();
			}
			if (conn != null) {
				conn.close();
			}
		}

		return costList;
	}

	private List<List<String>> getPriceListDetails(String itemCode) throws Exception
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", item = "" , descr="" ,   rate = "" , currCode = "" , effFrom = "" , validUpto = "" , prvNrv = "" ;
		List<List<String>> priceList = new ArrayList<>();
		try 
		{
			conn = getConnection();
			sql = "SELECT prt.item_code,it.descr,prt.rate, prt.eff_from, prt.valid_upto, prt.curr_code, prt.previous_nrv FROM pricelist prt left join item it on prt.item_code= it.item_code  WHERE prt.item_code = ? ORDER BY eff_from DESC";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode.trim());
			rs = pstmt.executeQuery();
			while (rs.next()) 
			{
				
				item = checkNull(rs.getString("item_code"));
				descr= checkNull(rs.getString("descr"));
				rate = checkNull(rs.getString("rate"));
				effFrom = checkNull(rs.getString("eff_from"));
				validUpto = checkNull(rs.getString("valid_upto"));
				currCode = checkNull(rs.getString("curr_code"));
				prvNrv = checkNull(rs.getString("previous_nrv"));
				
				SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
				Date effFromDate = simpleDateFormat.parse(effFrom);
				Date validUptoDate = simpleDateFormat.parse(validUpto);

				SimpleDateFormat displayFormat = new SimpleDateFormat("dd/MM/yy");
				String formattedEffFrom = displayFormat.format(effFromDate);
				String formattedValidUpto = displayFormat.format(validUptoDate);
			
				List<String> row = new ArrayList<>();
				
				row.add(item);
				row.add(descr);
				row.add(rate);
				row.add(formattedEffFrom);
				row.add(formattedValidUpto);
				row.add(currCode);
				row.add(prvNrv);
				priceList.add(row);
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("3", getUserInfo(), null, "Exception in getPriceListDetails: " + e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			
			if (rs != null) {
				rs.close();
			}
			if (pstmt != null) {
				pstmt.close();
			}
			if (conn != null) {
				conn.close();
			}
		}

	return priceList;
}

private String checkNull(String str) 
{
	return (str == null) ? "" : str;
}

}


